// ==UserScript==
// @name         5ch アンカー計測（+N表示のみ・動的対応）
// @namespace    http://tampermonkey.net/
// @version      1.2
// @description  「+N」を表示するのみ。ポップアップ表示は別スクリプトに任せる。
// @author       ChatGPT
// @match        *://*.5ch.net/test/read.cgi/*
// @grant        none
// @require      https://code.jquery.com/jquery-3.6.0.min.js
// ==/UserScript==

(function() {
    'use strict';

    const postsById = new Map();
    const mentionMap = new Map();

    function updatePosts() {
        const posts = Array.from(document.querySelectorAll('div.clear.post'));
        posts.forEach(post => {
            const postIdElem = post.querySelector('span.postid');
            if (!postIdElem) return;

            const id = postIdElem.textContent.trim();
            if (!postsById.has(id)) {
                postsById.set(id, post);
            }
        });
        return posts;
    }

    function analyzeAnchors(posts) {
        posts.forEach(post => {
            const fromIdElem = post.querySelector('span.postid');
            if (!fromIdElem) return;
            const fromId = fromIdElem.textContent.trim();

            const anchors = post.querySelectorAll('span.custom_reply[data-href]');
            anchors.forEach(anchor => {
                const href = anchor.getAttribute('data-href');
                const match = href?.match(/\/(\d+)$/);
                if (match) {
                    const targetId = match[1];
                    if (postsById.has(targetId)) {
                        if (!mentionMap.has(targetId)) mentionMap.set(targetId, []);
                        if (!mentionMap.get(targetId).includes(fromId)) {
                            mentionMap.get(targetId).push(fromId);
                        }
                    }
                }
            });
        });
    }

    function renderMentionCounts() {
        mentionMap.forEach((sources, targetId) => {
            const post = postsById.get(targetId);
            if (!post) return;

            const postidSpan = post.querySelector('span.postid');
            if (!postidSpan || postidSpan.parentNode.querySelector('.mention-count')) return;

            const mentionCount = document.createElement('span');
            mentionCount.className = 'mention-count';
            mentionCount.textContent = `+${sources.length}`;
            mentionCount.dataset.mentionPostIds = JSON.stringify(sources);

            postidSpan.parentNode.insertBefore(mentionCount, postidSpan.nextSibling);
        });
    }

    // CSS
    if (!document.getElementById('mention-count-style')) {
        const style = document.createElement('style');
        style.id = 'mention-count-style';
        style.textContent = `
            .mention-count {
                cursor: pointer;
                user-select: none;
                font-size: 0.9em;
                margin-left: 6px;
                color: #b33;
                font-weight: bold;
                border: 1px solid #384384;
                padding: 0 2px;
                display: inline-block;
                position: relative;
                vertical-align: middle;
            }
        `;
        document.head.appendChild(style);
    }

    function update() {
        const posts = updatePosts();
        analyzeAnchors(posts);
        renderMentionCounts();
    }

    // 初回実行
    update();

    // MutationObserver で動的追加に対応
    const target = document.body;
    const observer = new MutationObserver((mutationsList) => {
        let shouldUpdate = false;
        for (const mutation of mutationsList) {
            if ([...mutation.addedNodes].some(node => node.nodeType === 1 && node.matches && node.matches('div.clear.post, div.clear'))) {
                shouldUpdate = true;
                break;
            }
        }
        if (shouldUpdate) {
            setTimeout(update, 300); // debounce 的に少し遅らせる
        }
    });

    observer.observe(target, {
        childList: true,
        subtree: true
    });

})();
